/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.parts.CableRenderMode;
import appeng.api.parts.PartHelper;
import appeng.client.EffectType;
import appeng.client.Hotkeys;
import appeng.client.gui.style.StyleManager;
import appeng.client.render.effects.EnergyParticleData;
import appeng.client.render.effects.ParticleTypes;
import appeng.client.render.overlay.OverlayManager;
import appeng.client.render.tesr.InscriberTESR;
import appeng.client.render.tesr.SkyChestTESR;
import appeng.core.AEConfig;
import appeng.core.AppEngBase;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.MouseWheelPacket;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.BlockAttackHook;
import appeng.hooks.RenderBlockOutlineHook;
import appeng.hotkeys.HotkeyActions;
import appeng.init.client.InitAdditionalModels;
import appeng.init.client.InitAutoRotatingModel;
import appeng.init.client.InitBlockColors;
import appeng.init.client.InitBlockEntityRenderers;
import appeng.init.client.InitBuiltInModels;
import appeng.init.client.InitEntityLayerDefinitions;
import appeng.init.client.InitEntityRendering;
import appeng.init.client.InitItemColors;
import appeng.init.client.InitItemModelsProperties;
import appeng.init.client.InitParticleFactories;
import appeng.init.client.InitRenderTypes;
import appeng.init.client.InitScreens;
import appeng.init.client.InitStackRenderHandlers;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public class AppEngClient
extends AppEngBase {
    private static final String KEY_CATEGORY = "key.ae2.category";
    private static AppEngClient INSTANCE;
    private CableRenderMode prevCableRenderMode = CableRenderMode.STANDARD;

    public AppEngClient() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::registerParticleFactories);
        modEventBus.addListener(this::registerTextures);
        modEventBus.addListener(this::modelRegistryEvent);
        modEventBus.addListener(this::registerBlockColors);
        modEventBus.addListener(this::registerItemColors);
        modEventBus.addListener(this::registerEntityRenderers);
        modEventBus.addListener(this::registerEntityLayerDefinitions);
        BlockAttackHook.install();
        RenderBlockOutlineHook.install();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, e -> {
            if (e.phase == TickEvent.Phase.START) {
                this.updateCableRenderMode();
            }
        });
        InitAutoRotatingModel.init(modEventBus);
        modEventBus.addListener(this::clientSetup);
        INSTANCE = this;
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                Hotkeys.checkHotkeys();
            }
        });
        AppEngClient.registerTests();
    }

    @Override
    public Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    @Override
    public void registerHotkey(String id) {
        Hotkeys.registerHotkey(id);
    }

    public static AppEngClient instance() {
        return Objects.requireNonNull(INSTANCE, "AppEngClient is not initialized");
    }

    public void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        InitParticleFactories.init();
    }

    public void registerTextures(TextureStitchEvent.Pre event) {
        SkyChestTESR.registerTextures(event);
        InscriberTESR.registerTexture(event);
    }

    public void registerBlockColors(ColorHandlerEvent.Block event) {
        InitBlockColors.init(event.getBlockColors());
    }

    public void registerItemColors(ColorHandlerEvent.Item event) {
        InitItemColors.init(event.getItemColors());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            this.postClientSetup(minecraft);
        });
        MinecraftForge.EVENT_BUS.addListener(this::wheelEvent);
        MinecraftForge.EVENT_BUS.register((Object)OverlayManager.getInstance());
        HotkeyActions.init();
    }

    private void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        InitEntityRendering.init((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
    }

    private void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        InitEntityLayerDefinitions.init((modelLayerLocation, layerDefinition) -> event.registerLayerDefinition(modelLayerLocation, () -> layerDefinition));
    }

    private void postClientSetup(Minecraft minecraft) {
        StyleManager.initialize(minecraft.m_91098_());
        InitScreens.init();
        InitStackRenderHandlers.init();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelRegistryEvent(ModelRegistryEvent event) {
        InitAdditionalModels.init();
        InitBlockEntityRenderers.init();
        InitItemModelsProperties.init();
        InitRenderTypes.init();
        InitBuiltInModels.init();
    }

    private void wheelEvent(InputEvent.MouseScrollEvent me) {
        if (me.getScrollDelta() == 0.0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            boolean mainHand = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof IMouseWheelItem;
            boolean offHand = player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof IMouseWheelItem;
            if (mainHand || offHand) {
                NetworkHandler.instance().sendToServer(new MouseWheelPacket(me.getScrollDelta() > 0.0));
                me.setCanceled(true);
            }
        }
    }

    public boolean shouldAddParticles(Random r) {
        return switch (Minecraft.m_91087_().f_91066_.f_92073_) {
            default -> throw new IncompatibleClassChangeError();
            case ParticleStatus.ALL -> true;
            case ParticleStatus.DECREASED -> r.nextBoolean();
            case ParticleStatus.MINIMAL -> false;
        };
    }

    @Override
    public HitResult getCurrentMouseOver() {
        return Minecraft.m_91087_().f_91077_;
    }

    @Override
    public void spawnEffect(EffectType effect, Level level, double posX, double posY, double posZ, Object o) {
        if (AEConfig.instance().isEnableEffects()) {
            switch (effect) {
                case Vibrant: {
                    this.spawnVibrant(level, posX, posY, posZ);
                    return;
                }
                case Energy: {
                    this.spawnEnergy(level, posX, posY, posZ);
                    return;
                }
                case Lightning: {
                    this.spawnLightning(level, posX, posY, posZ);
                    return;
                }
            }
        }
    }

    private void spawnVibrant(Level level, double x, double y, double z) {
        if (AppEngClient.instance().shouldAddParticles(Platform.getRandom())) {
            double d0 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d1 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d2 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.VIBRANT, x + d0, y + d1, z + d2, 0.0, 0.0, 0.0);
        }
    }

    private void spawnEnergy(Level level, double posX, double posY, double posZ) {
        float x = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)EnergyParticleData.FOR_BLOCK, posX + (double)x, posY + (double)y, posZ + (double)z, (double)(-x) * 0.1, (double)(-y) * 0.1, (double)(-z) * 0.1);
    }

    private void spawnLightning(Level level, double posX, double posY, double posZ) {
        Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.LIGHTNING, posX, posY + (double)0.3f, posZ, 0.0, 0.0, 0.0);
    }

    private void updateCableRenderMode() {
        CableRenderMode currentMode = PartHelper.getCableRenderMode();
        if (currentMode == this.prevCableRenderMode) {
            return;
        }
        this.prevCableRenderMode = currentMode;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        int x = (int)player.m_20185_();
        int y = (int)player.m_20186_();
        int z = (int)player.m_20189_();
        int range = 256;
        mc.f_91060_.m_109494_(x - 256, y - 256, z - 256, x + 256, y + 256, z + 256);
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        if (Platform.isServer()) {
            return super.getCableRenderMode();
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        return this.getCableRenderModeForPlayer((Player)player);
    }
}

